var dark = new FlxSprite();
dark.cameras = [camHUD];
dark.makeGraphic(FlxG.width, FlxG.height, FlxColor.BLACK);

var bar = new FlxSprite(880, 0).loadGraphic(Paths.image("game/mechanics/cdi/lampbar"));
bar.cameras = [camHUD];

bar.scale.set(4, 4);

var tick = new FlxSprite(899).loadGraphic(Paths.image("game/mechanics/cdi/lampbarTick"));
tick.cameras = [camHUD];
tick.scale.set(4, 4);
if (downscroll) tick.y = 418; else tick.y = 293;

var warning = new FlxSprite(780, 20).loadGraphic(Paths.image("game/mechanics/cdi/warning"));
warning.cameras = [camHUD];
warning.alpha = 0.001;
warning.scale.set(1.2, 1.2);

public var darkMeter:Float = 0;
public var mechanicActive:Bool = true;

function postCreate() {
	insert(members.indexOf(healthBar), dark);
	bar.screenCenter(FlxAxes.Y);
	add(bar);
	add(tick);
	add(warning);
}

function update(elapsed) {
	if (FlxG.keys.justPressed.SPACE) {
		if (darkMeter > 0) darkMeter -= 4;
    }
   if (mechanicActive) darkMeter += 0.03 * (elapsed * 120);
   if (darkMeter < 0) darkMeter = 0;
   
   if (downscroll) tick.y = FlxMath.lerp(tick.y, 418 - darkMeter*2.5, 0.2);
   else tick.y = FlxMath.lerp(tick.y, 293 + darkMeter*2.5, 0.2);
   dark.alpha = darkMeter/100;
   
   if (darkMeter > 60) {
	warning.alpha = (FlxMath.lerp(warning.alpha, 1, 0.15));
   } else warning.alpha = (FlxMath.lerp(warning.alpha, 0.001, 0.15));
  
}


